﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace CashierCrisis.Behaviors
{
    public class Parallel : Composite
    {
       [Category("Settings"), Description("If true, this behavior will only fail if all children fail.")]
        public bool AllFail { get; set; }
        [Category("Settings"), Description("If true, this behavior will only complete if all children complete.")]
        public bool AllComplete { get; set; }

        public Parallel()
            :base()
        {
            AllComplete = false;
            AllFail = false;
        }

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            int failures = 0;
            int completions = 0;

            for (int i = 0; i < Children.Count; i++)
            {
                Status status = Children[i].Execute(gameTime);


                if (status == Status.Failed)
                {
                    if (!AllFail)
                    {
                        return Failed;
                    }
                    else
                    {
                        failures++;

                        if (failures >= Children.Count)
                        {
                            return Failed;
                        }
                    }
                }

                if (status == Status.Completed)
                {
                    if (!AllComplete)
                    {
                        return Completed;
                    }
                    else
                    {
                        completions++;

                        if (completions >= Children.Count)
                        {
                            return Completed;
                        }
                    }
                }

            }

            return Running;
        }
    }
}
